# PowerShell Script to Set RestartApps Registry Value

# Registry Path
$registryPath = "HKCU:\Software\Microsoft\Windows NT\CurrentVersion\Winlogon"

# Registry Value Name
$registryValueName = "RestartApps"

# Registry Value
$registryValue = 1

# Check if the registry key exists
if (-not (Test-Path $registryPath)) {
    # Create the registry key if it doesn't exist
    New-Item -Path $registryPath -Force | Out-Null
}

# Set the registry value
Set-ItemProperty -Path $registryPath -Name $registryValueName -Value $registryValue

# Verify the registry value
$value = Get-ItemProperty -Path $registryPath -Name $registryValueName
Write-Host "Registry Value $($registryValueName): $($value.$registryValueName)"
