#!/bin/bash

# Must install as root/sudo
if [ `id -ur` -ne 0 ]; then
	echo "Insufficient permissions. Run as root"
	exit
fi

INPUT=$1

confirm_uninstall()
{
	if [ -z $INPUT ]; then
		printf "The agent will be stopped and removed from the system. Continue? [y/n]: "	
		read ANSWER
	else
		ANSWER=$INPUT
	fi

	if [ ! -z "$ANSWER" ] && [ "$ANSWER" == "y" -o "$ANSWER" == "yes" ]; then
		return 0
	else
		return 1
	fi
}

uninstall()
{
	echo ""

	# Step 1: Stop agent service
	printf "%-40s" "Stopping agent service:"
	/sbin/service nagent stop > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		echo "[ FAILED ]"
	else
		echo "[ OK ]"	
	fi
	
	rm /opt/nable/usr/lib/libodbc.so.2

	# Step 2: Remove agent rpms
	OLDVERSION=`rpm -qa | grep nagent-rhel5.1_64`
	if [[ -z $OLDVERSION ]]; then
		for rpm in nagent-rhel8_64 libgsoap libstdsoap2 libsoapdata libmodule \
	        libcachemanager libxmpp libnable2 libgloox ; do	
			if rpm -q $rpm > /dev/null 2>&1; then
 				printf "%-40s" "Removing $rpm"
 				rpm -e $rpm > /dev/null 2>&1
 				if [ $? -ne 0 ]; then
 					echo "[ FAILED ]"
	 			else
 					echo "[ OK ]"
 				fi
	 		fi
 		done
	else
		echo "Old version (below 10.0)"
		for rpm in nagent-rhel5.1_64 libgsoap libstdsoap2 libsoapdata libmodule \
	        libcachemanager libxmpp libnable2 libgloox ; do	
			if rpm -q $rpm > /dev/null 2>&1; then
 				printf "%-40s" "Removing $rpm"
 				rpm -e $rpm > /dev/null 2>&1
 				if [ $? -ne 0 ]; then
 					echo "[ FAILED ]"
	 			else
 					echo "[ OK ]"
 				fi
	 		fi
 		done
	fi
	# Step 2a: Optional for systemd only
	if [ -d /etc/systemd ]; then
		echo "Delete systemd items"
		rm -f /usr/lib/systemd/system/nagent.service
		echo "Clean /home/nagent"
		rm -f /home/nagent/lib*.so
		rm -f /home/nagent/nagent*		
	fi
	# Step 3: Cleanup left over folders
	rm -rf /var/log/n-central
	rm -f /opt/nable/usr/lib/lib*.so
	# Step 4: Cleanup crontab
	sed '/ root logrotate \/etc\/logrotate.d\/nagent >\/dev\/null/d' /etc/crontab > /tmp/crontab
    cp -f /tmp/crontab /etc/crontab
    rm -f /tmp/crontab	
}

confirm_uninstall
if [ $? -ne 0 ]; then
	exit
fi

uninstall

echo ""
echo "Finished agent uninstall"
